/* ================================================================================
 *	File:		halwraps.h
 *
 *	    Copyright (C) 1999, PCtel, Inc. All rights reserved.
 *
 *	Purpose:	Header file for HAL layer wrapper
 *
 *	Author:		William Hsu <william_hsu@pctel.com>
 *
 *	Date:		06/03/99
 *
 *	Revision History:
 *
 *	Date		Who		What
 *	----		---		----
 *  06/03/99	whsu	Creation
 * ================================================================================
 */
#ifndef HALWRAPS_H
#define HALWRAPS_H

#define ASIC7		0x60
#define SI3032		0x02

#define AUDIO_ROUTING
//#define CM_DRIVER_AUDIO_ROUTING   /* driver to driver; for PC-Chip CM8738 only */

/* MR Chipset */
//#define INTEL
//#define SIS540
#define VIA

/* Exported functions to PTSERIAL */
void HAL_Init(int iobase0, int iobase1);
void HAL_Deinit(int unused);
int HAL_DoInterrupt(void);
int HAL_GetTimer(void);

/* Exported functions to DSP */
void SetSampleFreq(int fs_index, int notused);
void SetAsicBufSize(int bufSize);
void RdASIC(void);
void WrASIC(void);
void RestartPt(void);
void WriteOutport(int cmd);
int ReadInport(void);
int CheckLineCurrent(void);
void SiPatch(void);
void WriteOutSiReg(int cmd);
void WriteSiReg(void);
int ReadSiReg(void);
void SetCodecGain(int gain);

/* Exported variables to DSP */
extern unsigned short lineCurrent;
extern unsigned long SiRegValueR[5];
extern unsigned long SiRegValueW[5];
extern int SiNumReg;
extern unsigned short ASICstatus;
extern unsigned short ASICerrCnt;
extern short afeTxPtr[128];
extern short afeRxPtr[128];


/* AUDIO_ROUTING */
#ifdef AUDIO_ROUTING
#ifdef VIA
#define SAMPLE_SIZE         24000
typedef struct {
  int audio_on;
  int last_filled;
  unsigned char buffer0[SAMPLE_SIZE];
  unsigned char buffer1[SAMPLE_SIZE];
  unsigned char buffer2[SAMPLE_SIZE];
} AUDIO_BUFFERS;

#else
#define SAMPLE_SIZE         8000
typedef struct {
  int audio_on;
  int last_filled;
  unsigned char buffer0[SAMPLE_SIZE];
  unsigned char buffer1[SAMPLE_SIZE];
  unsigned char buffer2[SAMPLE_SIZE];
} AUDIO_BUFFERS;

#endif
#endif /* END AUDIO_ROUTING */

#endif /* HALWRAPS_H */




